﻿#pragma once

namespace RTCam {

// Helper class for basic timing.
class BasicTimer final
{
public:
	BasicTimer();		// Initializes internal timer values.

	void Reset();		// Reset the timer to initial values.
	void Update();		// Update the timer's internal values.

	// Duration in seconds between the last call to Reset() and the last call to Update().
	float GetTotal() { return m_total; }

	// Duration in seconds between the previous two calls to Update().
	float GetDelta() { return m_delta; }

private:
	LARGE_INTEGER m_frequency;
	LARGE_INTEGER m_currentTime;
	LARGE_INTEGER m_startTime;
	LARGE_INTEGER m_lastTime;
	float m_total;
	float m_delta;
};

} // end namespace